<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Payment;

use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Entity\Storefront\Payment\Action as LogicAction;
use XCart\Logic\Entity\Storefront\Payment\Action\ActionData as LogicActionData;
use XCart\Logic\Entity\Storefront\Payment\Action\ActionMetaData as LogicActionMetaData;

class ResponseEnricher implements ResponseEnricherInterface
{
    /**
     * Enrich Response object with payment data ($request)
     */
    public function enrich(ResponseInterface $response, RequestInterface $request): ResponseInterface
    {
        // In this point request contains data from payment processor
        // we need to move some data to the response so the client can have access to it

        /** @var LogicAction $processorResult */
        $processorResult = $request->getPayload();

        /** @var LogicAction $output */
        $output = $response->getPayload();

        $output->setActionData(
            $this->convertActionData($processorResult->getActionData())
        );

        $output->setActionMetaData(
            $this->convertActionMetaData($processorResult->getActionMetaData())
        );

        return $response;
    }

    /**
     * @param LogicActionData[] $actionData
     *
     * @return LogicActionData[]
     */
    public function convertActionData(array $actionData): array
    {
        $result = [];
        foreach ($actionData as $data) {
            $result[] = (new LogicActionData())
                ->setName($data->getName())
                ->setValue($data->getValue());
        }

        return $result;
    }


    /**
     * @param LogicActionMetaData[] $actionMetaData
     *
     * @return LogicActionMetaData[]
     */
    public function convertActionMetaData(array $actionMetaData): array
    {
        $result = [];
        foreach ($actionMetaData as $data) {
            $result[] = (new LogicActionMetaData())
                ->setName($data->getName())
                ->setValue($data->getValue());
        }

        return $result;
    }
}
