<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Payment;

use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Event\Payment\PaymentActionEvent;

class RequestProcessor implements RequestProcessorInterface
{
    public const OUTPUT_CODE_PROLONGATION = 'R';
    public const OUTPUT_CODE_SILENT = 'W';
    public const OUTPUT_CODE_SEPARATE = 'E';
    public const OUTPUT_CODE_COMPLETED = 'S';
    public const OUTPUT_CODE_PENDING = 'P';
    public const OUTPUT_CODE_FAILED = 'F';


    public function __construct(
        private EventAssemblerInterface $eventAssembler,
        private RequestEnricherInterface $requestEnricher,
        private EventDispatcherInterface $eventDispatcher
    ) {
    }

    /**
     * Call payment processor and add payment data to Request object
     */
    public function process(RequestInterface $request): RequestInterface
    {
        // $request -> $event
        $event = $this->eventAssembler->assemble($request);

        // dispatch
        $event = $this->dispatchEvent($event);

        // $event -> $request
        return $this->requestEnricher->enrich($request, $event);
    }

    private function dispatchEvent(PaymentActionEvent $event): PaymentActionEvent
    {
        $eventName = 'xcart.payment.action.before';
        $this->eventDispatcher->dispatch($event, $eventName);

        $action = $event->getAction();

        $eventName = sprintf('xcart.payment.action.before.%s', $action);
        $this->eventDispatcher->dispatch($event, $eventName);

        $serviceName = $event->getProcessorServiceName();

        $eventName = sprintf('xcart.payment.action.%s.%s', $action, $serviceName);
        $this->eventDispatcher->dispatch($event, $eventName);

        $eventName = sprintf('xcart.payment.action.after.%s', $action);
        $this->eventDispatcher->dispatch($event, $eventName);

        $eventName = 'xcart.payment.action.after';
        $this->eventDispatcher->dispatch($event, $eventName);

        return $event;
    }
}
