<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Payment;

use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Event\Payment\PaymentActionEvent;
use XCart\Event\Payment\TransactionData as EventTransactionData;
use XCart\Factory\Logic\Entity\Storefront\Payment\Action\TransactionData as TransactionDataFactory;
use XCart\Logic\Entity\Storefront\Payment\Action;
use XCart\Logic\Entity\Storefront\Payment\Action\ActionData;
use XCart\Logic\Entity\Storefront\Payment\Action\ActionMetaData;
use XCart\Transformer\Event\Payment\BackendTransaction\Logic\Entity\Storefront\Payment\Action\BackendTransactionInterface as BackendTransactionTransformer;
use XCart\Transformer\Event\Payment\TransactionData\Logic\Entity\Storefront\Payment\Action\TransactionDataInterface as TransactionDataTransformer;

class RequestEnricher implements RequestEnricherInterface
{
    public function __construct(
        private TransactionDataTransformer $transactionDataTransformer,
        private BackendTransactionTransformer $backendTransactionTransformer,
        private TransactionDataFactory $transactionDataFactory
    ) {
    }

    public function enrich(RequestInterface $request, PaymentActionEvent $event): RequestInterface
    {
        // Fill request with event data (this method called after event dispatching)

        /** @var PayloadOwnerRequestInterface $request */
        /** @var Action $action */
        $action = $request->getPayload();

        $action->setValue($event->getValue())
            ->setNote($event->getOutputNote())
            ->setProcessorResult($event->getOutputCode())
            ->setData($this->createTransactionData($event->getOutputTransactionData()))
            ->setActionData($this->createActionData($event->getOutputData()))
            ->setActionMetaData($this->createActionMetaData($event->getOutputMetaData()))
        ;

        if ($backendTransaction = $event->getOutputBackendTransaction()) {
            $action->setBackendTransactions([$this->backendTransactionTransformer->transform($backendTransaction)]);
        }

        return $request;
    }

    /**
     * @param EventTransactionData[] $transactionData
     *
     * @return array
     */
    private function createTransactionData(array $transactionData): array
    {
        return array_map(fn ($data) => $this->transactionDataTransformer->transform($data), $transactionData);
    }

    /**
     * @param array $data
     *
     * @return ActionData[]
     */
    private function createActionData(array $data): array
    {
        $result = [];

        foreach ($data as $name => $value) {
            $result[] = (new ActionData())
                ->setName($name)
                ->setValue($value);
        }

        return $result;
    }

    /**
     * @param array $data
     *
     * @return ActionMetaData[]
     */
    private function createActionMetaData(array $data): array
    {
        $result = [];

        foreach ($data as $name => $value) {
            $result[] = (new ActionMetaData())
                ->setName($name)
                ->setValue($value);
        }

        return $result;
    }
}
