<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Payment;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\UpdateOne\Arguments\ArgumentsAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Event\Payment\PaymentActionEvent;
use XCart\Factory\Event\Payment\PaymentActionEventInterface;
use XCart\Logic\Entity\Storefront\Payment\Action;
use XLite\Model\Payment\Transaction;

class EventAssembler implements EventAssemblerInterface
{
    public function __construct(
        private PaymentActionEventInterface $factory,
        private ReadRepositoryInterface $readRepository,
        private ArgumentsAssemblerInterface $argumentsAssembler,
    ) {
    }

    public function assemble(RequestInterface $request): PaymentActionEvent
    {
        $event = $this->factory->create();

        // fill event with data from request and from DataBase (Transaction entity)

        /** @var PayloadOwnerRequestInterface $request */
        /** @var Action $action */
        $action = $request->getPayload();

        $event->setInput($action);

        // @todo: use data_source after ECOM-3177
        $arguments = $this->argumentsAssembler->assemble($request);
        /** @var Transaction $transaction */
        $transaction = $this->readRepository->findOneBy($arguments);

        $event->setTransaction($transaction);

        // Value need to be set in case Payment Action Processor will not change it
        $event->setValue($transaction->getValue());

        return $event;
    }
}
