<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Operation\Service\Translation;

final class TranslationCreateBaseResult
{
    protected string $moduleDir = '';

    protected string $ignoredLabelsFilePath = '';

    public function setModuleDir(string $moduleDir): self
    {
        $this->moduleDir = $moduleDir;

        return $this;
    }

    public function getModuleDir(): string
    {
        return $this->moduleDir;
    }

    public function setIgnoredLabelsFilePath(string $path): self
    {
        $this->ignoredLabelsFilePath = $path;

        return $this;
    }

    public function getIgnoredLabelsFilePath(): string
    {
        return $this->ignoredLabelsFilePath;
    }
}
