<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Operation\Service\Translation;

final class TranslationCreateBaseConfig
{
    protected ?TranslationParsedData $data = null;

    protected string $authorId = '';

    protected string $moduleNameId = '';

    protected string $rootDir = LC_DIR_ROOT . 'var/packs';

    protected string $moduleBaseDir = LC_DIR_ROOT . 'var/packs/xcart';

    protected string $ignoredLabelsFilename = '';

    public function setData(TranslationParsedData $data): self
    {
        $this->data = $data;

        return $this;
    }

    public function getData(): TranslationParsedData
    {
        return $this->data;
    }

    public function setAuthorId(string $authorId): self
    {
        $this->authorId = $authorId;

        return $this;
    }

    public function getAuthorId(): string
    {
        return $this->authorId;
    }

    public function setModuleNameId(string $moduleNameId): self
    {
        $this->moduleNameId = $moduleNameId;

        return $this;
    }

    public function getModuleNameId(): string
    {
        if (
            !$this->moduleNameId
            && $this->data
            && ($lngCode = $this->data->getLngCode())
        ) {
            return strtoupper(($lngCode[0] ?? '')) . strtolower(substr($lngCode, 1)) . 'Translation';
        }

        return $this->moduleNameId;
    }

    public function getModuleId(): string
    {
        return $this->getAuthorId() . '-' . $this->getModuleNameId();
    }

    public function getModuleSubdir(): string
    {
        return 'modules/' . $this->getAuthorId() . '/' . $this->getModuleNameId();
    }

    public function setRootDir(string $rootDir): self
    {
        $this->rootDir = $rootDir;

        return $this;
    }

    public function getRootDir(): string
    {
        return $this->rootDir;
    }

    public function setModuleBaseDir(string $dir): self
    {
        $this->moduleBaseDir = $dir;

        return $this;
    }

    public function getModuleBaseDir(): string
    {
        return $this->moduleBaseDir;
    }

    public function setIgnoredLabelsFilename(string $filename): self
    {
        $this->ignoredLabelsFilename = $filename;

        return $this;
    }

    public function getIgnoredLabelsFilename(): string
    {
        if ($this->ignoredLabelsFilename) {
            return $this->ignoredLabelsFilename;
        }

        $result = 'ignored-labels';

        if (
            $this->data
            && ($lngCode = $this->data->getLngCode())
        ) {
            $result .= "-{$lngCode}";
        }

        return $result . '-' . date('Y-m-d-H.i.s') . '.csv';
    }
}
