<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Operation\Service\Storefront\Address;

use XCart\Logic\Entity\Storefront\NewAddress as LogicNewAddress;
use XCart\Logic\Entity\Storefront\Address as LogicAddress;

class SetAddressFields implements SetAddressFieldsInterface
{
    /**
     * @param LogicNewAddress|LogicAddress $logicEntity
     */
    public function __invoke(
        object $logicEntity,
        \XLite\Model\Address $entity
    ): void {
        /** @var \XCart\Logic\Entity\Storefront\AddressFieldValue $field */
        foreach ($this->getSortedFields($logicEntity) as $field) {
            $fieldName  = $field->getServiceName();
            $fieldValue = $field->getValue();

            switch ($fieldName) {
                case 'country_code':
                    $entity->setCountryCode($fieldValue);
                    break;
                case 'state_id':
                    if ($fieldValue) {
                        $entity->setStateId($fieldValue);
                    } else {
                        $entity->setState(null);
                        $entity->setterProperty($fieldName, $fieldValue);
                    }

                    break;
                case 'email':
                    break;
                default:
                    $entity->setterProperty($fieldName, $fieldValue);
            }
        }
    }

    private function getSortedFields(object $logicEntity): array
    {
        $result = $logicEntity->getFields();

        $countryAndStateFields = [
            'country_code' => null,
            'state_id'     => null,
            'custom_state' => null,
        ];

        $countryAndStateFieldKeys = array_keys($countryAndStateFields);

        /** @var \XCart\Logic\Entity\Storefront\AddressFieldValue $field */
        foreach ($logicEntity->getFields() as $key => $field) {
            $serviceName = $field->getServiceName();

            if (in_array($serviceName, $countryAndStateFieldKeys, true)) {
                $countryAndStateFields[$serviceName] = $field;
                unset($result[$key]);
            }
        }

        return array_merge(
            array_filter(array_values($countryAndStateFields)),
            $result
        );
    }
}
