<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Operation\Service\API;

class GetPathsWithCartId implements GetPathsWithCartIdInterface
{
    public function __invoke(): array
    {
        return [
            '/api/storefront/carts/{cart_id}/items',
            '/api/storefront/carts/{cart_id}/items/{id}',
            '/api/storefront/carts/{cart_id}/calculatedShippingRates',
            '/api/storefront/carts/{cart_id}/payment_methods',
            '/api/storefront/carts/{cart_id}/payment_methods/{id}',
            '/api/storefront/carts/{cart_id}/select_shipping_method',
            '/api/storefront/carts/{cart_id}/select_payment_method',
            '/api/storefront/carts/{cart_id}/merge',
            '/api/storefront/carts/{cart_id}/payment/{id}',
            '/api/storefront/carts/{cart_id}/addresses',
            '/api/storefront/carts/{cart_id}/addresses/{id}',
            '/api/storefront/carts/{cart_id}/change_email',
            '/api/storefront/carts/{cart_id}/order',
        ];
    }
}
