<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Messenger\Message;

class Import
{
    private int $id;

    private array $data;

    private string $processorClass;

    private array $options;

    public function __construct(int $id = null, array $data = [], string $processorClass = null, array $options = [])
    {
        $this->id             = $id;
        $this->data           = $data;
        $this->processorClass = $processorClass;
        $this->options        = $options;
    }

    public function getData(): array
    {
        return $this->data;
    }

    public function getProcessorClass(): string
    {
        return $this->processorClass;
    }

    public function getOptions(): array
    {
        return $this->options;
    }

    public function getId(): int
    {
        return $this->id;
    }
}
