<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Messenger\Handler;

use Symfony\Component\Messenger\Handler\MessageHandlerInterface;
use XCart\Messenger\Message\ResizeImage;
use XLite\Core\Database;
use XLite\Model\Base\Image;

class ResizeImageHandler implements MessageHandlerInterface
{
    public function __invoke(ResizeImage $message)
    {
        /** @var Image $image */
        $image = Database::getRepo($message->getClass())->find($message->getId());

        if ($image) {
            $this->correctSize($image);
            $image->prepareSizes();
        }
    }

    /**
     * XCB-2925 is narrower than BUG-5814 from \XLite\Logic\ImageResize\Step\AStep::correctSize()
     * therefore correct only height-0,width-0 cases for performance gaines
     */
    protected function correctSize(Image $storage): void
    {
        if (
            (!$storage->getWidth() || !$storage->getHeight())
            && $this->isProcessImageStorageCheck($storage)
            && is_array($data = @getimagesize($storage->getStoragePath()))
        ) {
            $storage->setWidth((int)$data[0]);
            $storage->setHeight((int)$data[1]);
        }
    }

    protected function isProcessImageStorageCheck(Image $storage): bool
    {
        return $storage->isFileExists(null, true);
    }
}
