<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Messenger\Handler;

use Doctrine\ORM\EntityManagerInterface;
use Exception;
use Symfony\Component\Messenger\Handler\MessageHandlerInterface;
use XCart\Messenger\Message\Import;
use XLite\Logic\Import\Console\Importer;
use XLite\Logic\Import\Processor\AProcessor;
use XLite\Model\TmpVar;

class ImportHandler implements MessageHandlerInterface
{
    private EntityManagerInterface $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function __invoke(Import $message): void
    {
        /** @var TmpVar $tmpVar */
        $tmpVar = $this->em->getRepository(TmpVar::class)->find($message->getId());
        if (!$tmpVar) {
            return;
        }

        $importer = new Importer($message->getOptions());
        $processorClass = $message->getProcessorClass();

        /** @var AProcessor $processor */
        $processor = new $processorClass($importer);

        try {
            foreach ($message->getData() as $data) {
                $processor->process($data, AProcessor::MODE_IMPORT);
            }
            $tmpVar->delete();
        } catch (Exception $e) {
            $tmpVar->setValue(json_encode(['error' => $e->getMessage()]));
        }

        $this->em->flush();
        $this->em->clear();
    }
}
