<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Logic\Decorator\RequestEnricher\Profile;

use Symfony\Component\Security\Core\Security;
use Symfony\Component\Security\Core\User\InMemoryUser;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestUserOwnerInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\DTO\Request\ProfileOwnerRequestInterface;

class ProfileOwnerEnrichDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private Security $security,
    ) {
    }

    /**
     * @param RequestUserOwnerInterface $request
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        if ($request instanceof ProfileOwnerRequestInterface) {
            $user    = $this->security->getUser();
            $profile = $this->isAnonimous($user)
                ? null
                : $user?->getWrappedProfile();

            $request->setProfile($profile);
        }

        return $this->inner->run($request);
    }

    private function isAnonimous($user)
    {
        return (
            $user instanceof InMemoryUser
            && $user->getUserIdentifier() === 'read_only'
        );
    }
}
