<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Logic\DTO\Request;

use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

trait NullableIdRequestTrait
{
    private ?int $id;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(?int $id): RequestInterface
    {
        $this->id = $id;

        return $this;
    }
}
