<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Logic\DTO\Request;

use XLite\Model\Cart as CartModel;

trait CartRequestTrait
{
    private ?CartModel $cart = null;

    public function getCart(): ?CartModel
    {
        return $this->cart;
    }

    public function setCart(?CartModel $cart): static
    {
        $this->cart = $cart;

        return $this;
    }
}
