<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\User\UpdateOne\Enricher;

use XCart\Bundle\DoctrineBridgeBundle\Enricher\UpdateOne\EntityEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;
use XCart\Logic\Entity\Storefront\User;
use XLite\Core\Auth;

class TransparentEnricherDecorator implements EntityEnricherInterface
{
    public function __construct(
        private EntityEnricherInterface $inner,
    ) {
    }

    /**
     * @param \XLite\Model\Profile                                      $entity
     * @param \XCart\Logic\Action\Storefront\User\UpdateOne\DTO\Request $request
     *
     * @return \XLite\Model\Profile
     */
    public function enrich(EntityInterface $entity, PayloadOwnerRequestInterface $request): EntityInterface
    {
        /** @var User $payload */
        $payload = $request->getPayload();

        if ($password = $payload->getPassword()) {
            $encryptedNewPassword = Auth::encryptPassword($password);
            $payload->setPassword($encryptedNewPassword);
        } else {
            $payload->setPassword($entity->getPassword());
        }

        return $this->inner->enrich($entity, $request);
    }
}
