<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\User\GetOne\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\EntityId\EntityIdAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\IdBasedRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class EntityIdAssembler implements EntityIdAssemblerInterface
{
    public function __construct(
        private EntityIdAssemblerInterface $inner,
    ) {
    }

    public function assemble(IdBasedRequestInterface|RequestInterface $request): int
    {
        return (int) $request->getProfile()?->getProfileId();
    }
}
