<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\User\Common\Decorator;

use Symfony\Component\Validator\ConstraintViolation;
use Symfony\Component\Validator\ConstraintViolationList;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Decorator\Validator\Request\Assembler\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Entity\Storefront\User as InputUser;
use XLite\Model\Repo\Profile as ProfileRepo;

class UniqueLoginValidator implements ActionInterface
{
    /**
     * @param ProfileRepo $profileRepository
     */
    public function __construct(
        private ActionInterface $inner,
        private ReadRepositoryInterface $profileRepository,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        /** @var InputUser $inputUser */
        $inputUser = $request->getPayload();

        if (
            ($inputLogin = $inputUser->getLogin())
            && (
               ($profile = $this->profileRepository->findByLogin($inputLogin))
                && $profile->getProfileId() !== $inputUser->getId()
            )
        ) {
            $violationList = new ConstraintViolationList();
            $violationList->add(
                new ConstraintViolation(
                    "login: This email address is already in use by another user.",
                    null,
                    [],
                    $request,
                    null,
                    get_class($request)
                ),
            );

            return $this->responseAssembler->assemble($violationList);
        }

        return $this->inner->run($request);
    }
}
