<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\ShippingMethodSelection\CreateOne;

use ApiPlatform\Exception\InvalidArgumentException;
use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Cart\ShippingMethodSelection\CreateOne\DTO\Request;
use XCart\Logic\Action\Storefront\Cart\ShippingMethodSelection\CreateOne\DTO\Response;
use XCart\Logic\Entity\Storefront\Cart\NewShippingMethodSelection;
use XLite\Logic\Order\Modifier\Shipping as ShippingModifier;
use XLite\Model\Base\Surcharge;
use XLite\Model\Repo\Cart as CartRepository;

class Action implements ActionInterface
{
    public function __construct(
        private CartRepository $cartWriteRepository,
        private EntityManagerInterface $entityManager,
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $newShippingMethodSelection = $request->getPayload();

        $shippingMethodId = $newShippingMethodSelection->getShippingMethodId();
        $cartId           = $newShippingMethodSelection->getCartId();
        $cart             = $this->cartWriteRepository->find($cartId);

        /** @var ?ShippingModifier $modifier */
        $modifier = $cart->getModifier(Surcharge::TYPE_SHIPPING, 'SHIPPING')?->getModifier();

        $shippingMethod = null;

        /** @var \XLite\Model\Shipping\Rate $rate */
        foreach ($modifier->getRates() as $rate) {
            $cartShippingMethod = $rate->getMethod();

            if ($cartShippingMethod->getMethodId() === $shippingMethodId) {
                $shippingMethod = $cartShippingMethod;
            }
        }

        if (!$shippingMethod) {
            throw new InvalidArgumentException('Cannot find shipping method');
        }

        $cart->setShippingId($shippingMethodId);
        $cart->updateOrder();

        $this->entityManager->flush();

        return (new Response())
            ->setPayload(
                (new NewShippingMethodSelection())
                    ->setId($cartId)
                    ->setCartId($cartId)
                    ->setShippingMethodId($shippingMethodId)
            );
    }
}
