<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Product\GetOne\Assembler\QueryBuilder;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\EntityId\EntityIdAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class FindOneQueryBuilderAssembler implements FindOneQueryBuilderAssemblerInterface
{
    /**
     * @param \XLite\Model\Repo\Product $productRepository
     */
    public function __construct(
        private ReadRepositoryInterface $productRepository,
        private EntityIdAssemblerInterface $entityIdAssembler,
    ) {
    }

    public function assemble(RequestInterface $request): QueryBuilderInterface
    {
        $id = $this->entityIdAssembler->assemble($request);

        $qb = $this->productRepository
            ->createPureQueryBuilder('p')
            ->linkLeft('p.memberships', 'm')
            ->andWhere('p.product_id = :id')
            ->andWhere('p.enabled = 1')
            ->setParameter('id', $id);

        if ($membershipId = $request->getProfile()?->getMembershipId()) {
            $qb->andWhere('m.membership_id = :membershipId OR m.membership_id IS NULL')
                ->setParameter('membershipId', $membershipId);
        } else {
            $qb->andWhere('m.membership_id IS NULL');
        }

        return $qb;
    }
}
