<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Product\GetList\Resolver;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Resolver\FilterApplierResolverInterface;
use XCart\DataSource\Product\Applier\SubstringApplier;
use XCart\Operation\Service\DataSource\Product\Applier\SubstringApplier\GetLinkedTablesInterface;
use XCart\Operation\Service\DataSource\Product\Applier\SubstringApplier\GetSubstringSearchFieldsInterface;

class SubstringFilterApplierResolverDecorator implements FilterApplierResolverInterface
{
    public function __construct(
        private FilterApplierResolverInterface $inner,
        private GetLinkedTablesInterface $getLinkedTables,
        private GetSubstringSearchFieldsInterface $getSubstringSearchFields
    ) {
    }

    public function resolve(string $property, FilterValueInterface $value): ?ApplierInterface
    {
        if ($property === 'substring') {
            return new SubstringApplier(
                $this->getLinkedTables,
                $this->getSubstringSearchFields
            );
        }

        return $this->inner->resolve($property, $value);
    }
}
