<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Product\GetList\Enricher\OrderRule;

use XCart\Bundle\DoctrineBridgeBundle\DTO\OrderRule\OrderRuleInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\OrderRule\QueryBuilderOrderRuleEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class PriceOrderRuleEnricherDecorator implements QueryBuilderOrderRuleEnricherInterface
{
    public function __construct(
        private QueryBuilderOrderRuleEnricherInterface $inner
    ) {
    }

    public function enrich(OrderRuleInterface $filter, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        if ($priceFilter = $filter->getPrice()) {
            $joinConditions = [];
            $conditions     = [
                'membership' => null,
                'zone'       => null,
            ];

            foreach ($conditions as $condName => $condValue) {
                if (is_null($condValue)) {
                    $joinConditions[] = 'qd.' . $condName . ' is null';
                } else {
                    $joinConditions[] = 'qd.' . $condName . ' = :' . $condName;
                    $queryBuilder->setParameter($condName, $condValue);
                }
            }

            $queryBuilder->innerJoin(
                'entity.quickData',
                'qd',
                'WITH',
                implode(' AND ', $joinConditions)
            );

            $queryBuilder->orderBy('qd.price', $priceFilter->getValue());

            $filter->setPrice(null);
        }

        return $this->inner->enrich($filter, $queryBuilder);
    }
}
