<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Product\GetList\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Assembler\FieldNameAssemblerInterface;

class IdFieldNameAssemblerDecorator implements FieldNameAssemblerInterface
{
    public function __construct(
        private FieldNameAssemblerInterface $inner
    ) {
    }

    public function assemble(string $propertyName): string
    {
        if ($propertyName === 'id') {
            return 'entity.product_id';
        }

        return $this->inner->assemble($propertyName);
    }
}
