<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Product\GetList\Assembler\Criteria;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetList\Criteria\FindListCriteriaAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\DTO\FindListCriteria;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\IntegerValue;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\BooleanFilterStrategyType;
use XCart\Bundle\DoctrineBridgeBundle\Enum\FilterStrategy\NumberFilterStrategyType;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\DTO\Doctrine\Storefront\Product\Filter;

class FindListCriteriaAssemblerDecorator implements FindListCriteriaAssemblerInterface
{
    public function __construct(
        private FindListCriteriaAssemblerInterface $inner,
    ) {
    }

    /**
     * @param \XCart\Logic\Action\Storefront\Product\GetList\DTO\Request $request
     */
    public function assemble(RequestInterface $request): FindListCriteria
    {
        $criteria = $this->inner->assemble($request);

        /** @var Filter $filter */
        $filter = $criteria->getFilter();

        $filter->setEnabled(
            (new BooleanValue())
                ->setValue(true)
                ->setStrategy(BooleanFilterStrategyType::EXACT())
        );

        $filter->setMembership(
            (new IntegerValue())
                ->setValue((int) $request->getProfile()?->getMembershipId())
                ->setStrategy(NumberFilterStrategyType::EXACT())
        );

        return $criteria;
    }
}
