<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Product\Detailed\GetOneByCleanURL\DTO;

use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Logic\DTO\Request\ProfileOwnerRequestInterface;
use XCart\Logic\DTO\Request\ProfileOwnerRequestTrait;

class Request implements RequestInterface, ProfileOwnerRequestInterface
{
    use ProfileOwnerRequestTrait;

    private string $cleanURL;

    public function getCleanURL(): string
    {
        return $this->cleanURL;
    }

    public function setCleanURL(string $cleanURL): Request
    {
        $this->cleanURL = $cleanURL;

        return $this;
    }
}
