<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Product\Detailed\GetOneByCleanURL\Assembler;

use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\EntityId\EntityIdAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\IdBasedRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Logic\Action\Storefront\Product\Detailed\GetOneByCleanURL\DTO\Request;
use XLite\Model\Repo\CleanURL as CleanURLRepository;

class EntityIdAssembler implements EntityIdAssemblerInterface
{
    use LoggerAwareTrait;

    /**
     * @param CleanURLRepository $cleanURLRepository
     */
    public function __construct(
        private ReadRepositoryInterface $cleanURLRepository,
        LoggerInterface $logger,
    ) {
        $this->setLogger($logger);
    }

    /**
     * @param Request $request
     *
     * @return int
     */
    public function assemble(IdBasedRequestInterface|RequestInterface $request): int|string
    {
        $productId = $this->cleanURLRepository->createQueryBuilder('entity')
            ->select('product.product_id')
            ->linkInner('entity.product', 'product')
            ->andWhere('entity.cleanURL = :cleanURL')
            ->setParameter('cleanURL', $request->getCleanURL())
            ->getSingleScalarResult();

        if (!$productId) {
            $this->logger->error('Clean URL not associated with category');

            return 0;
        }

        return (int) $productId;
    }
}
