<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\PaymentMethodSelection\CreateOne;

use ApiPlatform\Exception\InvalidArgumentException;
use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Cart\PaymentMethodSelection\CreateOne\DTO\Request;
use XCart\Logic\Action\Storefront\Cart\PaymentMethodSelection\CreateOne\DTO\Response;
use XCart\Logic\Entity\Storefront\Cart\NewPaymentMethodSelection;
use XLite\Model\Payment\Method as PaymentMethodModel;
use XLite\Model\Repo\Cart as CartRepository;

class Action implements ActionInterface
{
    public function __construct(
        private CartRepository $cartWriteRepository,
        private EntityManagerInterface $entityManager,
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $newPaymentMethodSelection = $request->getPayload();

        $paymentMethodId = $newPaymentMethodSelection->getPaymentMethodId();
        $cartId          = $newPaymentMethodSelection->getCartId();
        $cart            = $this->cartWriteRepository->find($cartId);

        $paymentMethod = null;

        /** @var PaymentMethodModel $paymentMethod */
        foreach ($cart->getPaymentMethods() as $cartPaymentMethod) {
            if ($cartPaymentMethod->getMethodId() === $paymentMethodId) {
                $paymentMethod = $cartPaymentMethod;
                break;
            }
        }

        if (!$paymentMethod) {
            throw new InvalidArgumentException('Cannot find payment method');
        }

        $cart->setPaymentMethod($paymentMethod);
        $cart->updateOrder();

        $this->entityManager->flush();

        return (new Response())
            ->setPayload(
                (new NewPaymentMethodSelection())
                    ->setId($cartId)
                    ->setCartId($cartId)
                    ->setPaymentMethodId($paymentMethodId)
            );
    }
}
