<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\PaymentMethod\GetOne;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Bundle\LogicBundle\Factory\Response\ResponseFactoryInterface;
use XCart\Logic\Action\Storefront\Cart\PaymentMethod\GetOne\DTO\Request;
use XCart\Logic\Action\Storefront\Cart\PaymentMethod\GetOne\DTO\Response;
use XCart\Transformer\XLite\Model\Payment\Method\Logic\Entity\Storefront\Cart\PaymentMethodInterface as PaymentMethodTransformer;
use XLite\Model\Payment\Method as PaymentMethodModel;

class Action implements ActionInterface
{
    public function __construct(
        private ResponseFactoryInterface $responseFactory,
        private PaymentMethodTransformer $transformer
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $id   = $request->getId();
        $cart = $request->getCart();

        /** @var PaymentMethodModel $paymentMethod */
        foreach ($cart->getPaymentMethods() as $paymentMethod) {
            if ($paymentMethod->getMethodId() === $id) {
                return $this->responseFactory->create()
                    ->setPayload(
                        $this->transformer->transform($paymentMethod, $cart)
                    );
            }
        }

        return (new DefaultFailedResponse())
            ->setType('Not found')
            ->setTitle('Cannot find entity')
            ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
    }
}
