<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\PaymentMethod\GetCollection;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Bundle\LogicBundle\Factory\Response\ResponseFactoryInterface;
use XCart\Logic\Entity\Storefront\Cart\PaymentMethod as PaymentMethodLogicDto;
use XCart\Logic\Action\Storefront\Cart\PaymentMethod\GetList\DTO\Request;
use XCart\Logic\Action\Storefront\Cart\PaymentMethod\GetList\DTO\Response;
use XCart\Transformer\XLite\Model\Payment\Method\Logic\Entity\Storefront\Cart\PaymentMethodInterface as PaymentMethodTransformer;
use XLite\Model\Payment\Method as PaymentMethodModel;

class Action implements ActionInterface
{
    public function __construct(
        private ResponseFactoryInterface $responseFactory,
        private PaymentMethodTransformer $transformer
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $cart = $request->getCart();

        $responseDTOList = array_map(
            fn (PaymentMethodModel $method): PaymentMethodLogicDto => $this->transformer->transform($method, $cart),
            $cart->getPaymentMethods()
        );

        return $this->responseFactory->create()
            ->setPayload($responseDTOList);
    }
}
