<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\PaymentAction\UpdateOne;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Payment\RequestProcessorInterface;
use XCart\Payment\ResponseEnricherInterface;

class PaymentActionDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private RequestProcessorInterface $requestProcessor,
        private ResponseEnricherInterface $responseEnricher
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        // Add payment data to request object
        $request = $this->requestProcessor->process($request);

        // Enrich response from parent call with payment data ($request)
        // Doctrine entity will be enriched inside parent call
        return $this->responseEnricher->enrich($this->inner->run($request), $request);
    }
}
