<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Logic\Action\Storefront\PaymentAction\UpdateOne\Enricher;

use XCart\Bundle\CommonBundle\Enricher\Transparent\TransparentEnricherInterface;
use XCart\Logic\Entity\Storefront\Payment\Action;
use XCart\Payment\RequestProcessor;
use XLite\Model\Payment\Transaction;

class EntityEnricher implements TransparentEnricherInterface
{
    /**
     * Enrich Doctrine Entity ($initial) with data from Logic Entity ($input)
     */
    public function enrich(object $initial, object $input): object
    {
        // In this point Logic entity contains data from payment processor
        // we need to move some data to Doctrine entity to store it to the DB

        /** @var Transaction $initial */
        /** @var Action $input */

        // Set Transaction status by payment result code
        $processorResultCode = (string) $input->getProcessorResult();

        if ($processorResultCode) {
            $paymentTransactionStatus = $this->convertProcessingResultToTransactionStatus($processorResultCode);
            $initial->setStatus($paymentTransactionStatus);
        }

        foreach ($input->getData() as $data) {
            $initial->setDataCell($data->getName(), $data->getValue(), $data->getLabel(), $data->getAccessLevel());
        }

        if (($note = $input->getNote())) {
            $initial->setNote($note);
        }

        foreach ($input->getBackendTransactions() as $backendTransactionData) {
            $backendTransaction = $initial->createBackendTransaction($backendTransactionData->getType());

            $backendTransaction->setStatus(
                $this->convertProcessingResultToTransactionStatus($backendTransactionData->getStatus())
            );
            $backendTransaction->setValue($backendTransactionData->getValue());

            foreach ($backendTransactionData->getData() as $data) {
                $backendTransaction->setDataCell($data->getName(), $data->getValue(), $data->getLabel());
            }
        }

        $initial->setValue($input->getValue());

        return $initial;
    }

    private function convertProcessingResultToTransactionStatus(string $processingResult): string
    {
        return match ($processingResult) {
            RequestProcessor::OUTPUT_CODE_PROLONGATION, RequestProcessor::OUTPUT_CODE_SILENT, RequestProcessor::OUTPUT_CODE_SEPARATE => Transaction::STATUS_INPROGRESS,
            RequestProcessor::OUTPUT_CODE_COMPLETED => Transaction::STATUS_SUCCESS,
            RequestProcessor::OUTPUT_CODE_PENDING => Transaction::STATUS_PENDING,
            default => Transaction::STATUS_FAILED,
        };
    }
}
