<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\PaymentAction\GetOne;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Bundle\LogicBundle\Factory\Response\ResponseFactoryInterface;
use XCart\Logic\Action\Storefront\Payment\Action\GetOne\DTO\Request;
use XCart\Logic\Action\Storefront\Payment\Action\GetOne\DTO\Response;
use XCart\Transformer\XLite\Model\Payment\Transaction\Logic\Entity\Storefront\Payment\ActionInterface as PaymentActionTransformer;
use XLite\Model\Payment\Transaction as PaymentTransactionModel;

class Action implements ActionInterface
{
    public function __construct(
        private ResponseFactoryInterface $responseFactory,
        private PaymentActionTransformer $transformer
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $id   = $request->getId();
        $cart = $request->getCart();

        /** @var PaymentTransactionModel $paymentTransaction */
        foreach ($cart->getPaymentTransactions() as $paymentTransaction) {
            if ($paymentTransaction->getPublicTxnId() === $id) {
                return $this->responseFactory->create()
                    ->setPayload(
                        $this->transformer->transform($paymentTransaction)
                    );
            }
        }

        return (new DefaultFailedResponse())
            ->setType('Not found')
            ->setTitle('Cannot find entity')
            ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
    }
}
