<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Country\GetList\Enricher\OrderRule;

use XCart\Bundle\DoctrineBridgeBundle\DTO\OrderRule\OrderRuleInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\OrderRule\QueryBuilderOrderRuleEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class NameOrderRuleEnricherDecorator implements QueryBuilderOrderRuleEnricherInterface
{
    public function __construct(private QueryBuilderOrderRuleEnricherInterface $inner)
    {
    }

    public function enrich(OrderRuleInterface $filter, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        return $queryBuilder->addOrderBy('translations.country');
    }
}
