<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Config\GetOne;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Config\ConfigValueResolverInterface;
use XLite\Model\Config;

class Action implements ActionInterface
{
    public function __construct(
        private ResponseAssemblerInterface $responseAssembler,
        private ConfigValueResolverInterface $configValueResolver
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $id = $request->getId();
        [$category, $name] = explode('-', $id);

        if (!$category || !$name) {
            return (new DefaultFailedResponse())
                ->setType('Not found')
                ->setTitle('Cannot find entity')
                ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
        }

        $value = $this->configValueResolver->getConfigValue($category, $name);

        if ($value === null) {
            return (new DefaultFailedResponse())
                ->setType('Not found')
                ->setTitle('Cannot find entity')
                ->setStatus(HTTPResponse::HTTP_NOT_FOUND);
        }

        $config = (new Config())
            ->setCategory($category)
            ->setName($name)
            ->setValue($value);

        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return $this->responseAssembler->assemble($config);
    }
}
