<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Config\GetList;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetList\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Config\ConfigValueResolverInterface;
use XLite\Model\Config;

class Action implements ActionInterface
{
    public function __construct(
        private ResponseAssemblerInterface $responseAssembler,
        private ConfigValueResolverInterface $configValueResolver
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $configParams = $request->getFilter()->getSelected()->getValue();

        $configs = [];

        $itemsPerPage   = $request->getItemsPerPage();
        $pageIndex      = $request->getPageIndex();
        $firstItemIndex = $pageIndex * $itemsPerPage - 1;

        for ($i = $firstItemIndex; $i < $firstItemIndex + $itemsPerPage; $i++) {
            if (!isset($configParams[$i])) {
                break;
            }

            [$category, $name] = explode('|', $configParams[$i], 2);

            $value     = $this->configValueResolver->getConfigValue($category, $name);
            $configs[] = (new Config())
                ->setCategory($category)
                ->setName($name)
                ->setValue($value);
        }

        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return $this->responseAssembler->assemble($configs);
    }
}
