<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Logic\Action\Storefront\Config;

class ConfigValueResolverCurrencyDecorator implements ConfigValueResolverInterface
{
    public function __construct(
        private ConfigValueResolverInterface $inner,
        private \Xlite $xlite
    ) {
    }

    public function getConfigValue(string $category, string $name): ?string
    {
        if ($category === 'Currency') {
            $value = match ($name) {
                'currency_code'   => $this->xlite->getCurrency()->getCode(),
                'currency_symbol' => $this->xlite->getCurrency()->getSymbol(),
                'currency_prefix' => $this->xlite->getCurrency()->getPrefix(),
                'currency_suffix' => $this->xlite->getCurrency()->getSuffix(),
                default => null
            };

            if ($value !== null) {
                return $value;
            }
        }

        return $this->inner->getConfigValue($category, $name);
    }
}
