<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Logic\Action\Storefront\Config;

use XLite\Core\ConfigCell;

class ConfigValueResolver implements ConfigValueResolverInterface
{
    public function __construct(
        private ConfigCell $config
    ) {
    }

    public function getConfigValue(string $category, string $name): ?string
    {
        if (str_contains($category, '\\')) {
            [$author, $module] = explode('\\', $category, 2);
            $value = $this->config->$author?->$module?->$name;
        } else {
            $value = $this->config->$category?->$name;
        }

        return ($value === null) ? null : (string) $value;
    }
}
