<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Logic\Action\Storefront\Common\Enricher;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadListOwnerResponseInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\DTO\Request\CartRequestInterface;

class CartEnrichDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $response = $this->inner->run($request);

        if (
            $request instanceof CartRequestInterface
            && $request->getCart()
        ) {
            $cartId = $request->getCart()->getPublicId();

            if ($response instanceof PayloadListOwnerResponseInterface) {
                foreach ($response->getPayload() as $entity) {
                    $this->enrichCartId($entity, $cartId);
                }
            } elseif ($response instanceof PayloadOwnerResponseInterface) {
                $this->enrichCartId($response->getPayload(), $cartId);
            }
        }

        return $response;
    }

    private function enrichCartId($object, $value): void
    {
        if (method_exists($object, 'setCartId')) {
            $object->setCartId($value);
        }
    }
}
