<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Category\GetOneByCleanURL\Assembler;

use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\EntityId\EntityIdAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\IdBasedRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Logic\Action\Storefront\Category\GetOneByCleanURL\DTO\Request;
use XLite\Model\Category;
use XLite\Model\Repo\Category as CategoryRepository;

class EntityIdAssembler implements EntityIdAssemblerInterface
{
    use LoggerAwareTrait;

    /**
     * @param CategoryRepository $categoryRepository
     */
    public function __construct(
        private ReadRepositoryInterface $categoryRepository,
        LoggerInterface $logger,
    ) {
        $this->setLogger($logger);
    }

    /**
     * @param Request $request
     *
     * @return int
     */
    public function assemble(IdBasedRequestInterface|RequestInterface $request): int|string
    {
        /** @var Category $category */
        $category = null;
        $parent = $this->categoryRepository->getRootCategory();
        foreach (explode('/', $request->getCleanURL()) as $path) {
            $category = $this->categoryRepository->createQueryBuilder('entity')
                ->linkInner('entity.cleanURLs', 'cleanURL')
                ->andWhere('cleanURL.cleanURL = :cleanURL AND entity.parent = :parent')
                ->setParameter('cleanURL', $path)
                ->setParameter('parent', $parent)
                ->getSingleResult();

            if (!$category) {
                return 0;
            }

            $parent = $category;
        }

        return $category ? $category->getCategoryId() : 0;
    }
}
