<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\CartItem\UpdateOne\Enricher;

use XCart\Bundle\DoctrineBridgeBundle\Enricher\UpdateOne\EntityEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;
use XCart\Logic\Action\Storefront\CartItem\Common\Assembler\ModelAttributeValuesAssemblerInterface;

class AttributeValuesEnricherDecorator implements EntityEnricherInterface
{
    public function __construct(
        private EntityEnricherInterface $inner,
        private ModelAttributeValuesAssemblerInterface $attributeValuesAssembler,
    ) {
    }

    public function enrich(EntityInterface $entity, PayloadOwnerRequestInterface $request): EntityInterface
    {
        $entity = $this->inner->enrich($entity, $request);

        $this->attributeValuesAssembler->assemble($entity, $entity->getProduct(), $request->getPayload());

        return $entity;
    }
}
