<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\CartItem\GetOne\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Logic\Entity\Storefront\Cart\Item as CartItemLogicEntity;
use XLite\Model\Order\Surcharge as SurchargeModel;
use XLite\Model\OrderItem as OrderItemModel;

class ResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
    ) {
    }

    /**
     * @param OrderItemModel $entity
     */
    public function assemble(EntityInterface $entity): PayloadOwnerResponseInterface
    {
        $response = $this->inner->assemble($entity);

        /** @var CartItemLogicEntity $logicEntity */
        $logicEntity = $response->getPayload();

        $logicSurcharges = [];
        /** @var SurchargeModel $surcharge */
        foreach ($entity->getSurcharges() as $surcharge) {
            $logicSurcharges[] = (new CartItemLogicEntity\Surcharge())
                ->setName($surcharge->getName())
                ->setType($surcharge->getType())
                ->setValue($surcharge->getValue())
            ;
        }
        $logicEntity->setSurcharges($logicSurcharges);

        $logicAttributeValues = [];
        foreach ($entity->getAttributeValues() as $attributeValue) {
            $value = (string) $attributeValue->getActualValue();

            $logicAttributeValues[] = (new CartItemLogicEntity\AttributeValue())
                ->setName($attributeValue->getAttributeValue()?->getAttribute()->getName())
                ->setAttributeId($attributeValue->getAttributeId())
                ->setAttributeValue($value)
                ->setAttributeValueId($attributeValue->getAttributeValueId())
            ;
        }
        $logicEntity->setAttributes($logicAttributeValues);

        return $response;
    }
}
