<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\CartItem\DeleteOne\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\DeleteOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Cart\Item\DeleteOne\DTO\Response as DeleteOneResponse;
use XLite\Model\OrderItem as OrderItemModel;

class CalculationResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
        private WriteRepositoryInterface $writeRepository,
    ) {
    }

    /**
     * @param OrderItemModel $entity
     *
     * @return DeleteOneResponse
     */
    public function assemble(EntityInterface $entity): ResponseInterface
    {
        $entity->getOrder()->updateOrder();

        $this->writeRepository->updateEntity($entity->getOrder());

        return $this->inner->assemble($entity);
    }
}
