<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\CartItem\CreateOne\Assembler;

use ApiPlatform\Exception\InvalidArgumentException;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XLite\Model\OrderItem;
use XLite\Model\Repo\Cart as CartRepository;

class ResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
        private CartRepository $cartWriteRepository,
    ) {
    }

    /**
     * @param OrderItem $entity
     */
    public function assemble(EntityInterface $entity): PayloadOwnerResponseInterface
    {
        $key = $entity->getKey();

        $cart = $entity->getOrder();
        $cart->updateOrder();

        $this->cartWriteRepository->updateEntity($cart);

        $found = false;
        foreach ($cart->getItems() as $item) {
            if ($item->getKey() === $key) {
                $entity = $item;
                $found = true;
                break;
            }
        }

        if (!$found) {
            throw new InvalidArgumentException('Cannot find product');
        }

        return $this->inner->assemble($entity);
    }
}
