<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\CartItem\Common\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Logic\Action\Storefront\Cart\Item\CreateOne\DTO\Response as CreateOneResponse;
use XCart\Logic\Action\Storefront\Cart\Item\UpdateOne\DTO\Response as UpdateOneResponse;
use XLite\Model\OrderItem as OrderItemModel;

class CalculationResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
        private WriteRepositoryInterface $writeRepository,
    ) {
    }

    /**
     * @param OrderItemModel $entity
     *
     * @return CreateOneResponse|UpdateOneResponse
     */
    public function assemble(EntityInterface $entity): PayloadOwnerResponseInterface
    {
        $entity->getOrder()->updateOrder();

        $this->writeRepository->updateEntity($entity->getOrder());

        return $this->inner->assemble($entity);
    }
}
