<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\CartEmailChanging\CreateOne;

use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Cart\EmailChanging\CreateOne\DTO\Request;
use XCart\Logic\Action\Storefront\Cart\EmailChanging\CreateOne\DTO\Response;
use XCart\Logic\Entity\Storefront\Cart\NewEmailChanging;
use XLite\Model\Cart as CartModel;
use XLite\Model\Repo\Cart as CartRepository;

class Action implements ActionInterface
{
    public function __construct(
        private CartRepository $cartWriteRepository,
        private EntityManagerInterface $entityManager,
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $newCartEmailChanging = $request->getPayload();

        $email  = $newCartEmailChanging->getEmail();
        $cartId = $newCartEmailChanging->getCartId();

        /** @var CartModel $cart */
        $cart = $this->cartWriteRepository->find($cartId);

        $profile = $cart->getProfile();

        if ($profile->getAnonymous()) {
            $profile->setLogin($email);
        } else {
            $profile->setLastCheckoutEmail($email);
        }

        $cart->updateOrder();

        $this->entityManager->flush();

        return (new Response())
            ->setPayload(
                (new NewEmailChanging())
                    ->setId($cartId)
                    ->setEmail($email)
                    ->setCartId($cartId)
            );
    }

    private function cloneOrigProfile(CartModel $cart): void
    {
        $origProfile = $cart->getOrigProfile();
        $profile     = $cart->getProfile();

        if (
            $origProfile
            && $origProfile->getProfileId() === $profile->getProfileId()
        ) {
            $clonedProfile = $origProfile->cloneEntity();
            $cart->setProfile($clonedProfile);
            $clonedProfile->setOrder($cart);
        }
    }
}
