<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\CartCalculatedShippingRates\CreateOne;

use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Entity\Storefront\Cart\NewCalculatedShippingRates;
use XLite\Model\Cart as CartModel;
use XLite\Model\Repo\Cart as CartRepository;

class SetDefaultShippingMethodActionDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private CartRepository $cartReadRepository,
        private EntityManagerInterface $entityManager,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $response = $this->inner->run($request);

        /** @var NewCalculatedShippingRates $payload */
        $payload = $response->getPayload();

        /** @var CartModel $cart */
        $cart = $this->cartReadRepository->find($payload->getCartId());

        if (!$cart->getShippingId()) {
            $rates = $payload->getRates();

            if (isset($rates[0])) {
                $cart->setShippingId($rates[0]->getMethod()->getId());
                $cart->updateOrder();
                $this->entityManager->flush();
            }
        }

        return $response;
    }
}
