<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Cart\UpdateOne\Enricher;

use XCart\Bundle\DoctrineBridgeBundle\Enricher\UpdateOne\EntityEnricherInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;
use XLite\Model\Cart as CartModel;

class CalculationEnricherDecorator implements EntityEnricherInterface
{
    public function __construct(
        private EntityEnricherInterface $inner,
        private WriteRepositoryInterface $writeRepository,
    ) {
    }

    /**
     * @param CartModel $entity
     *
     * @return CartModel
     */
    public function enrich(EntityInterface $entity, PayloadOwnerRequestInterface $request): EntityInterface
    {
        $entity = $this->inner->enrich($entity, $request);

        /** @var CartModel $entity */
        $entity->updateOrder();

        $this->writeRepository->updateEntity($entity);

        return $entity;
    }
}
