<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Cart\GetOne;

use Symfony\Component\HttpFoundation\Response as HTTPResponse;
use Throwable;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\EntityId\EntityIdAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\DataSource\WriteDataSourceInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Cart\CreateOne\DTO\Request;
use XCart\Logic\Action\Storefront\Cart\CreateOne\DTO\Response;
use XLite\Model\Cart as CartModel;

class RenewCartActionDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private EntityIdAssemblerInterface $entityIdAssembler,
        private WriteDataSourceInterface $cartWriteDataSource,
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        $cartId = $this->entityIdAssembler->assemble($request);

        try {
            /** @var ?CartModel $cart */
            $cart = $this->cartWriteDataSource->findOne($cartId);
        } catch (Throwable $e) {
            return (new DefaultFailedResponse())
                ->setType('Internal error')
                ->setTitle(sprintf('Cannot read entity from DB: %s', $e))
                ->setStatus(HTTPResponse::HTTP_INTERNAL_SERVER_ERROR);
        }

        if ($cart) {
            $cart->renew();
            $this->cartWriteDataSource->update($cart);
        }

        return $this->inner->run($request);
    }
}
