<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Cart\GetOne\Assembler;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Logic\Entity\Storefront\Cart as CartLogicEntity;
use XCart\Logic\Entity\Storefront\Cart\ShippingMethod;
use XLite\Model\Cart as CartModel;
use XLite\Model\Order\Surcharge as SurchargeModel;

class ResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
    ) {
    }

    /**
     * @param CartModel $entity
     */
    public function assemble(EntityInterface $entity): PayloadOwnerResponseInterface
    {
        $response = $this->inner->assemble($entity);

        /** @var CartLogicEntity $logicEntity */
        $logicEntity = $response->getPayload();

        if ($entity->getShippingId()) {
            $shipping = (new ShippingMethod())
                ->setId($entity->getShippingId())
                ->setName($entity->getShippingMethodName());
            $logicEntity->setShipping($shipping);
        }

        $logicSurcharges = [];
        /** @var SurchargeModel $surcharge */
        foreach ($entity->getSurcharges() as $surcharge) {
            $logicSurcharges[] = (new CartLogicEntity\Surcharge())
                ->setName($surcharge->getName())
                ->setType($surcharge->getType())
                ->setValue($surcharge->getValue());
        }
        $logicEntity->setSurcharges($logicSurcharges);

        return $response;
    }
}
