<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Cart\CreateOne;

use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Cart\CreateOne\DTO\Request;
use XCart\Logic\Action\Storefront\Cart\CreateOne\DTO\Response;
use XLite\Model\Repo\Cart;

class UniqueCartActionDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private Cart $cartReadRepository,
        private ResponseAssemblerInterface $responseAssembler,
    ) {
    }

    /**
     * @param Request $request
     *
     * @return Response
     */
    public function run(RequestInterface $request): ResponseInterface
    {
        if ($request->getPayload()->getProfileId()) {
            $cart = $this->cartReadRepository->findOneBy(['orig_profile' => $request->getPayload()->getProfileId()]);
            if ($cart) {
                return $this->responseAssembler->assemble($cart);
            }
        }

        return $this->inner->run($request);
    }
}
