<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Logic\Action\Storefront\Cart\CreateOne\Assembler;

use Doctrine\ORM\EntityManagerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\CreateOne\Entity\EntityAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PayloadOwnerRequestInterface;
use XCart\Logic\Action\Storefront\Cart\CreateOne\DTO\Request as RequestLogic;
use XLite\Model\Cart as CartModel;
use XLite\Model\Profile as ProfileModel;
use XLite\Model\Repo\Profile;

class EntityAssemblerDecorator implements EntityAssemblerInterface
{
    public function __construct(
        private EntityAssemblerInterface $inner,
        private Profile $profileRepository,
        private EntityManagerInterface $entityManager,
    ) {
    }

    /**
     * @param RequestLogic $request
     *
     * @return CartModel
     */
    public function assembler(PayloadOwnerRequestInterface $request): EntityInterface
    {
        $profileId = $request->getPayload()->getProfileId();

        /** @var CartModel $entity */
        $entity = $this->inner->assembler($request);

        if ($profileId) {
            $profile = $this->profileRepository->find($profileId);
            $entity->setProfile($profile);
            $entity->setOrigProfile($profile);
        } else {
            $entity->setProfile(
                $this->createAnonymousCartProfile($entity)
            );
        }

        $entity->updateOrder();

        return $entity;
    }

    private function createAnonymousCartProfile(CartModel $cart): ProfileModel
    {
        $profile = new ProfileModel();
        $profile->setLogin('');
        $profile->setOrder($cart);
        $profile->setAnonymous(true);

        $cart->setProfile($profile);

        $this->entityManager->flush();

        return $profile;
    }
}
